/* Stored Proecudure to Log the cpu history values into a table. Code adapted from posting by Bejamnin Nevarez so it logs into a table
and then checks for new records when it runs again using the MERGE statement. Create a job that runs every x minutes to log data. 
Original article can be found here http://sqlblog.com/blogs/ben_nevarez/archive/2009/07/26/getting-cpu-utilization-data-from-sql-server.aspx */
use dba_BaseLine
GO
create Procedure usp_CpuHistory
AS
SET NOCOUNT ON
declare @ts_now bigint
select @ts_now = cpu_ticks / (cpu_ticks/ms_ticks) from sys.dm_os_sys_info;
CREATE TABLE #CPU_USAGE
(
	Record_ID INT,
	EventTime datetime,
	SQLProcessUtilization INT,
	SystemIdle INT,
	OtherProcessUtilization INT
	)

INSERT INTO #cpu_usage     
select record_id,
      dateadd(ms, -1 * (@ts_now - [timestamp]), GetDate()) as EventTime,
      SQLProcessUtilization,
      SystemIdle,
      100 - SystemIdle - SQLProcessUtilization as OtherProcessUtilization
from (
      select
            record.value('(./Record/@id)[1]', 'int') as record_id,
            record.value('(./Record/SchedulerMonitorEvent/SystemHealth/SystemIdle)[1]', 'int') as SystemIdle,
            record.value('(./Record/SchedulerMonitorEvent/SystemHealth/ProcessUtilization)[1]', 'int') as SQLProcessUtilization,
            timestamp
      from (
            select timestamp, convert(xml, record) as record
            from sys.dm_os_ring_buffers
            where ring_buffer_type = N'RING_BUFFER_SCHEDULER_MONITOR'
            and record like '%<SystemHealth>%') as x
      ) as y
order by record_id desc

/*select * from #CPU_USAGE*/

MERGE dbo.Cpu_Usage AS TARGET
USING #CPU_USAGE AS SOURCE
ON (TARGET.Record_ID = SOURCE.Record_ID)
WHEN NOT MATCHED BY TARGET THEN
INSERT (Record_id,EventTime,SQLProcessUtilization,SystemIdle,OtherProcessUtilization)
VALUES (SOURCE.Record_id,SOURCE.EventTime,SOURCE.SQLProcessUtilization,SOURCE.SystemIdle,SOURCE.OtherProcessUtilization);
DROP TABLE #CPU_USAGE
 